/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.servlet.pmod.impl.nodes.util;

import com.ibm.hwmca.fw.servlet.pmod.ModelDefinitionException;
import com.ibm.hwmca.fw.servlet.pmod.PanelModel;
import com.ibm.hwmca.fw.servlet.pmod.PanelModelException;
import com.ibm.hwmca.fw.servlet.pmod.impl.nodes.util.StateChange;
import com.ibm.hwmca.fw.servlet.pmod.util.MarkupNodeInterface;
import com.ibm.hwmca.fw.util.Trace;

public class StateChangeImpl
implements StateChange {
    private static final String TRACE_MASKT = "XPMNUSCT";
    private static final String TRACE_MASKD = "XPMNUSCD";
    String target = null;
    String attribute = null;
    boolean newState;

    public StateChangeImpl(String target, String attribute, boolean newState) {
        this.target = target;
        this.attribute = attribute;
        this.newState = newState;
    }

    public void fire(PanelModel model) {
        block10: {
            Trace.trace(TRACE_MASKD, "StateChange.fire( " + model + " )");
            try {
                MarkupNodeInterface mni = model.getMarkupNode(this.target);
                if (mni != null) {
                    if ("enabled".equals(this.attribute)) {
                        if (mni.isEnableEnabled()) {
                            Trace.trace(TRACE_MASKD, "StateChange.fire() calls setEnabled(" + this.newState + ") on target.");
                            mni.setEnabled(this.newState);
                        } else {
                            Trace.trace(TRACE_MASKT, "StateChange.fire() target node is not appropriate for setEnabled() invocation.");
                        }
                    } else if ("visible".equals(this.attribute)) {
                        Trace.trace(TRACE_MASKD, "StateChange.fire() calls setShown(" + this.newState + ") on target.");
                        mni.setShown(this.newState);
                    } else {
                        Trace.trace(TRACE_MASKT, "StateChange.fire() asked to service unknown attribute (" + this.attribute + ") , ignoring.");
                    }
                    break block10;
                }
                Trace.trace(TRACE_MASKT, "StateChange.fire() unable to find target (name=" + this.target + "), ignoring.");
            }
            catch (PanelModelException e) {
                Trace.trace(TRACE_MASKT, "StateChange.fire() catches PanelModelException fetching node from model, ignoring.");
                Trace.trace(TRACE_MASKT, e);
            }
            catch (ModelDefinitionException e) {
                Trace.trace(TRACE_MASKT, "StateChange.fire() catches ModelDefinitionException fetching node from model, ignoring. Likely unknown target.");
                Trace.trace(TRACE_MASKT, e);
            }
        }
    }
}

